do_neutral_metacomm <- function(J, nu)
  {
  M = rep(0,J) # initial community contains only species 0
  S = 1
  Ss = c(S) # vector for species richness over time
  next_sp_id = 1 # species id for the next speciation event

  while ( sum(M==0) > 0 ) # loop over generations
    {
    death_ids = sample(J,J,replace=T)
    birth_ids = sample(J,J,replace=T)
    do_speciation = (runif(J)<nu)
    # loop over the J birth-death events in this generation
    for ( i in 1:J )      {
      if ( do_speciation[i] )
        {
        M[death_ids[i]] = next_sp_id
        next_sp_id = next_sp_id + 1
        } else
        {
        M[death_ids[i]] = M[birth_ids[i]]
        }
      }
    S = length(unique(M))
    Ss = c(Ss,S)
    }
  return(list(Ss=Ss,abunds=table(M)))
  } 
  
J = 1000 # community size
nu = 0.1 # speciation rate
comm = do_neutral_metacomm(J,nu)
plot(comm$Ss,type='l',xlab='Generations',
     ylab='Species richness')
theta = (J-1)*nu/(1-nu)
S_eq = theta*log(1/nu)
abline(h=S_eq,lty=2)
